pro test,a,n

; Solves linear equation system Ax=S (from Southwell article  1980, wavefront from wavefront slopes measurements

n=float(n)
psi=fltarr(n,n)
f=genfocus(n,1) ; generate slopes from focus array

win,2,256
tvscl,congrid(f(*,*,0),256,256)
win,3,256
tvscl,congrid(f(*,*,1),256,256)

S=genmats(f,n,-1.0) ; generate S matrix from slopes
A=(genmat(n))		; generate A corresponding to NxN matrix SH type
w=2/(1+sin(3.1415/(N+1))) ; weight factor to enhance convergence see southwell

; generate focus solution to compare with results
focus2d=focusarr(n,1)

; iterative GAUSS SIEDEL fonction
phas=gs_iter(A,S,/check,/double,lambda=w,max_iter=n^3,tol=1e-4)

psi(*)=phas(*)
print,(psi-min(psi))-(focus2d-min(focus2d))
print,stdev(psi),stdev(focus2d)

print,(psi-min(psi))/(focus2d-min(focus2d))
;print,mean((psi-min(psi))/(focus2d-min(focus2d)))
;print,stdev((psi-min(psi))/(focus2d-min(focus2d)))
win,0,256
tvscl,congrid(psi,256,256)


;SVDC, a, W, U, V,itmax=n^3
;phas2=SVSOL(U, W, V, s)
;psi2(0:n^2-1)=phas2(0:n^2-1)
;win,3,256
;tvscl,congrid(psi2,256,256)



end